/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Astroframe;

public class Supergal
extends Astroframe {
    static final char letterIAU = 'S';
    public static final double[] toGalMatrix = new double[]{-0.7357425748043749, -0.07455377836523375, 0.6731453021092076, 0.6772612964138943, -0.08099147130697673, 0.7312711658169645, 0.0, 0.9939225903997749, 0.11008126222478207};
    public static final double[] fromGalMatrix = new double[]{-0.7357425748043749, 0.6772612964138943, 0.0, -0.07455377836523375, -0.08099147130697673, 0.9939225903997749, 0.6731453021092076, 0.7312711658169645, 0.11008126222478207};
    public static final double[] fromICRSbase = new double[]{0.37501555570601913, 0.34135887185720826, 0.8618801851666389, -0.8983204377254853, -0.09572710025099693, 0.4287851600069993, 0.22887490937889643, -0.9350456902643366, 0.27075049949149177};
    public static final double[] toICRSbase = new double[]{0.37501555570601913, -0.8983204377254853, 0.22887490937889643, 0.34135887185720826, -0.09572710025099693, -0.9350456902643366, 0.8618801851666389, 0.4287851600069993, 0.27075049949149177};

    public static Supergal scan(double d) {
        if (DEBUG) {
            System.out.println("#...Supergal.scan(" + d + ")");
        }
        if (fixedFrames == null) {
            return null;
        }
        boolean bl = Double.isNaN(d);
        for (Object e : fixedFrames) {
            if (!(e instanceof Supergal)) continue;
            Supergal supergal = (Supergal)e;
            if (!(Math.abs(supergal.epoch - d) <= 3.168808781402895E-8)) continue;
            return supergal;
        }
        return null;
    }

    public static Supergal create(double d) {
        Supergal supergal = Supergal.scan(d);
        if (supergal == null) {
            supergal = new Supergal(d);
            supergal.fixFrame();
        }
        return supergal;
    }

    public static Supergal create() {
        return Supergal.create(2000.0);
    }

    public Supergal(double d) {
        if (Double.isNaN(d)) {
            d = 2000.0;
        }
        this.precision = (byte)5;
        this.epoch = d;
        this.name = "Supergal";
        this.full_name = "Supergal(Ep=J" + d + ")";
        this.toICRSmatrix = toICRSbase;
        this.fromICRSmatrix = fromICRSbase;
    }
}

